<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Roadway Setup Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis závislostí koridoru</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads/RoadwayDesigner">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis závislostí koridoru</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Roadway Designer Data -->
                            <!-- <xsl:for-each select="RoadwayDesigner"> -->
                                <table class="margin" cellpadding="2">
                                    <tbody>
                                        <tr>
                                            <th align="left" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left"><xsl:value-of select="@fileName"/></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Corridor Information -->
                                <table class="margin" width="95%">								    
									<xsl:for-each select="Corridor">
									<!-- Sort on Name descending -->
									 <xsl:sort select="@name" order="ascending" data-type="text" />
									 <table>
										<tbody>
											<thead style="display:table-header-group">
												<tr>
												    <td  align="left" colspan="7" lang="en"><strong>Koridor:&#xa0; </strong><xsl:value-of select="@name"/></td>
													<tr>
														<td  align="left"><strong>Směrové řešení:&#xa0; </strong><xsl:value-of select="@horizontalName"/></td>
													</tr>
													<tr>													
														<td  align="left"><strong>Výškové řešení:&#xa0;  </strong><xsl:value-of select="@verticalName"/></td>
													</tr>
												</tr>
											</thead>
											<tr><td>&#xa0;</td></tr>
										</tbody>
									 </table>
                                        <tr>
                                            <td>
												<table>
													<thead style="display:table-header-group">
													   <tr>
															<th align="left" colspan="7" lang="en">Řízení bodů</th>
														</tr>
														<tr>
															<th  lang="en">Priorita</th>
															<th  lang="en">Název bodu</th>
															<th  lang="en">Režim</th>
															<th  lang="en">Řízení Typ</th>
															<th  lang="en">Řízení Název</th>
															<th  lang="en">Název trasy řízení</th>
														</tr>
													</thead>										
                                                    <xsl:choose>
                                                        <xsl:when test="HVControls">
															<xsl:for-each select="HVControls/HVControl">
																<xsl:if test="@controlType = 'CorridorPoint'">
																	<tr>
																		<td  align="left"><strong><xsl:value-of select="@priority"/></strong></td>
																		<td  align="left"><strong><xsl:value-of select="@pointName"/></strong></td>
																		<td  align="left"><strong><xsl:value-of select="@mode"/></strong></td>
																		<td  align="left"><strong><xsl:value-of select="@controlType"/></strong></td>
																		<td  align="left"><strong><xsl:value-of select="@controlName"/></strong></td>
																		<td  align="left"><strong><xsl:value-of select="@controlParentName"/></strong></td>
																	</tr>
																</xsl:if>
																<xsl:if test="@controlType != 'CorridorPoint'">
																	<tr>
																		<td  align="left"><xsl:value-of select="@priority"/></td>
																		<td  align="left"><xsl:value-of select="@pointName"/></td>
																		<td  align="left"><xsl:value-of select="@mode"/></td>
																		<td  align="left"><xsl:value-of select="@controlType"/></td>
																		<td  align="left"><xsl:value-of select="@controlName"/></td>
																		<td  align="left"><xsl:value-of select="@controlParentName"/></td>
																	</tr>
																</xsl:if>
																
                                                            </xsl:for-each>
														
															
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <tr>
                                                                <td colspan="7" lang="en">Nepoužito řízení bodů</td>
                                                            </tr>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
													

                                                    <tr><td>&#xa0;</td></tr>
                                                </table>
                                            </td>
                                        </tr>
                                       
                                       
                                        <tr>
                                            <td>
                                                <table>
													<thead style="display:table-header-group">
														<tr>
															<th align="left" colspan="7" lang="en">Zástupné cíle</th>
														</tr>
														<tr>
															<th  align="right">Zástupný cíl Název</th>
															<th  align="right">Zástupný cíl Typ</th>
															<th  align="right">Alias Název </th>
														</tr>
													</thead>	
														<xsl:choose>
															<xsl:when test="TargetAliases">
																<xsl:for-each select="TargetAliases/TargetAlias">
																	 <td  valign="top"><xsl:value-of select="@name"/></td>
																	 <td  valign="top"><xsl:value-of select="@type"/></td>
																		<xsl:for-each select="Alias">
																			<tr>
																				<td/><td/><td  valign="top"><xsl:value-of select="@aliasName"/></td>
																			</tr>
																		</xsl:for-each>
																</xsl:for-each>		
															</xsl:when>
															<xsl:otherwise>
																<tr>
																	<td colspan="7" lang="en">Nepoužitý zástupný cíl</td>
																</tr>
															</xsl:otherwise>
														</xsl:choose>
														
													<tr><td>&#xa0;</td></tr>	
                                                </table>
                                            </td>
                                        </tr>
										<tr>
										    <td>
                                                <table>
													<thead style="display:table-header-group">
														<tr style="page-break-before:always">
															<th align="left" colspan="7" lang="en">Reference ořezání</th>
														</tr>
														<tr>
															<th  align="left">Název</th>
															<th  align="left">Typ</th>
														</tr>
													</thead>	
														<xsl:choose>
															<xsl:when test="ClippingReferences">
																<xsl:for-each select="ClippingReferences/ClippingReference">
																	<tr>
																		 <td  valign="top"><xsl:value-of select="@name"/></td>
																		 <td  valign="top"><xsl:value-of select="@type"/></td>	
																	</tr>
																</xsl:for-each>		
															</xsl:when>
															<xsl:otherwise>
																<tr>
																	<td align="left" colspan="7" lang="en">Nepoužito ořezání</td>
																</tr>
															</xsl:otherwise>
														</xsl:choose>
																										 
                                                </table>
												<hr/>
                                            </td>
                                        </tr>
                                      
                                    </xsl:for-each>
									<!-- </xsl:sort> -->
									
                                </table>
                            <!-- </xsl:for-each> -->
                        </xsl:for-each>
                </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Musíte otevřít soubor návrhu koridoru výběrem <em>Soubor &gt; Otevřít</em> v menu <em>Průzkumník výpisů</em>
				  a zadat <em>Typ souboru</em> a <em>Návrh cesty(*.ird)</em>.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2014 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
